﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using System.ComponentModel;

namespace PsgBase
{
    public class psgComboBox : ComboBox
    {
        #region Fields / Contructors

        public string initial_value = string.Empty;
        string valueKey = string.Empty;
        string fieldKey = string.Empty;
        string fieldName = string.Empty;
        string servertablename = string.Empty;
        string fieldType;
        bool notNull = false;
        public DataTable table;
        int hmn_loop;

        public void InitializeComponent()
        {
            this.SuspendLayout();
            // 
            // psgComboBox
            // 
            this.Click += new System.EventHandler(this.psgcombo_Click);
            this.Enter += new System.EventHandler(this.psgcombo_Enter);
            this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.psgcombo_KeyPress);
            this.Validating += new System.ComponentModel.CancelEventHandler(this.psgcombo_Validating);
            this.ResumeLayout(false);

        }

        public psgComboBox()
        {
            InitializeComponent();

            this.DataBindings.DefaultDataSourceUpdateMode = DataSourceUpdateMode.OnPropertyChanged;
        }

        #endregion

        #region Properties

        [Category("PSG")]
        public string PsgFieldType
        {
            get { return fieldType; }
            set { fieldType = value; }
        }

        [Category("PSG")]
        public bool PsgNotNull
        {
            get { return notNull; }
            set { notNull = value; }
        }

        [Category("PSG")]
        public string PsgFieldName
        {
            get { return fieldName; }
            set
            {
                fieldName = value;
            }
        }

        [Browsable(false)]
        public DataTable Table
        {
            get { return table; }
            set { table = value; }
        }

        [Category("PSG"), Browsable(false)]
        public string PsgValueKey
        {
            get { return valueKey; }
            set { valueKey = value; }
        }

        [Category("PSG")]
        public string PsgFieldKey
        {
            get { return fieldKey; }
            set { fieldKey = value; }
        }

        [Category("PSG")]
        public string PsgServerTableName
        {
            get { return servertablename; }
            set { servertablename = value; }
        }

        #endregion

        private void psgcombo_Validating(object sender, System.ComponentModel.CancelEventArgs e)
        {
            if (string.IsNullOrEmpty(this.PsgServerTableName) ||
                string.IsNullOrEmpty(this.PsgFieldKey) ||
                string.IsNullOrEmpty(this.PsgFieldName) ||
                string.IsNullOrEmpty(this.PsgFieldType))
            {
                MessageBox.Show("PSG properties are not set. ", "Attention!");
                return;
            }

            Intf.cmdResult = PsgMsg.NOK;
            if (psgUpdate(sender, Base.psgIntf.GetCurrentPK(this.PsgServerTableName)))
            {
                hmn_loop = 0;
                while (Intf.cmdResult != PsgMsg.OK && this.hmn_loop <= 200)
                {
                    Thread.Sleep(30);
                    this.hmn_loop = this.hmn_loop + 1;
                }

                if (Intf.cmdResult != PsgMsg.OK)
                {
                    MessageBox.Show("Check server connectivity and try again!", Base.GetIntl(ConstantsBase.Attention_), MessageBoxButtons.OK);
                    this.Text = this.initial_value;

                    Intf.cmdResult = PsgMsg.OK;

                    if (e != null)
                        e.Cancel = true;

                    return;
                }

                this.initial_value = this.Text;

                View view = ((Base)this.FindForm()).view;
                if (view != null && view is ViewGrid && view.bsEditor != null)
                {
                    if (this.DataBindings.Count == 1)
                        this.DataBindings[0].WriteValue();

                    if (this.DataBindings.Count == 2)
                    {
                        this.DataBindings[0].WriteValue();
                        this.DataBindings[1].WriteValue();
                    }

                    view.bsEditor.EndEdit();
                }
            }
        }
        public bool psgUpdate(object sender, string _id)
        {
            bool result;

            if (!string.IsNullOrEmpty(this.Text))
            {
                this.SelectedIndex = this.FindStringExact(this.Text);
                //this.SelectedText = this.Text;
            }

            if (this.SelectedIndex == -1)
            {
                this.Text = string.Empty;
                this.SelectedText = string.Empty;
                this.SelectedValue = string.Empty;
            }

            if (!Utils.StringEquals(this.Text, this.initial_value))
            {
                Base.kv = Base.GetParameters(_id, "C");
                Base.value = Base.GetParameters(Base.psgIntf.IsNull(this.SelectedValue, this.Text), fieldType);
                Base.psgIntf.send_command("UPDATEFIELD#'" + this.PsgServerTableName + "','" + this.PsgFieldKey
                + "'," + Base.kv + ",'" + this.PsgFieldName + "'," + Base.value);

                result = true;
            }
            else
                result = false;

            return result;
        }

        private void psgcombo_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == Convert.ToChar(13))
            {
                if (string.IsNullOrEmpty(this.PsgServerTableName) ||
                    string.IsNullOrEmpty(this.PsgFieldKey) ||
                    string.IsNullOrEmpty(this.PsgFieldName) ||
                    string.IsNullOrEmpty(this.PsgFieldType))
                {
                    MessageBox.Show("PSG properties are not set. ", "Attention!");
                    return;
                }

                psgUpdate(sender, Base.psgIntf.GetCurrentPK(this.PsgServerTableName));
                Base.bUpdate = false;
                SendKeys.Send("{TAB}");
                e.Handled = true;
            }
        }
        void psgcombo_Enter(object sender, EventArgs e)
        {
            if (this.FindForm() != null)
            {
                View view = ((Base)this.FindForm()).view;
                if (view == null || !(view is ViewGrid) || view.bsEditor == null)
                    this.initial_value = this.Text;
            }
        }
        private void psgcombo_Click(object sender, EventArgs e)
        {
            this.DroppedDown = true;
        }
    }
}
